### 概述

**使用场景**

* 制造业：智能工厂、自动化生产线。
* 能源管理：智能电网、可再生能源管理。
* 交通运输：智能交通系统、车联网。
* 医疗设备：远程监控和数据传输。
* 传感器和执行器：用于数据采集和控制。
* PLC（可编程逻辑控制器）：用于自动化控制。
* SCADA（监控与数据采集）系统：用于实时监控和数据分析。

**整体架构**
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c8075852e.png)

**主要功能及产品组件**

注： 本手册中用到的中科时代的软件包，均可以从官网的子页面获取。官网提供的版本可能比本手册中提到的版本更高，一般情况下这不会影响您按照本手册的例子执行相应的操作

* 监听第三方TCP/IP客户端的连接，确认第三方客户端的连接，进行数据的收发，从而实现通信，当长时间不需要通信时，可以关闭建立的连接。

* TCPIP Server产品包括两部分组件

| **产品组件**                 | **描述说明**    |
| ------------------------ | ----------- |
| sf4200\_0.0.5\_amd64.deb | TCPIP RTE组件 |
| CmpTcpIp.library         | 上位机程序使用的库文件 |

---
### 安装卸载

**安装要求**

* 中科时代出厂的工智机；

* 工智机可以访问互联网；

* 熟悉基础的Linux操作命令

**安装过程**

* TCPIP Server产品有两个组件，所以要使用TCPIP Server需要从安装这两个组件开始，下面将详细介绍：

**1、工智机端安装TCPIP RTE组件**

* 上传deb包到工智机Linux环境的/home/sinsegye目录下

* 上传完成后在工智机上执行命令安装（参考下方截图，如果模块文件名发生变化则命令行中的文件名做相应更改）
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c81941adb.png)


* 修改RTE的配置文件，ComponentManger模块下加入SF4200

* 重启RTE服务，使新加入的SF4200被调用

**2、IDE侧部署TCPIP Server的library**

* MetaFacture中点击最上面的菜单栏 ”工具“ -- ”库存储“ ；
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c824e70af.png)


* 弹出的对话窗中点击”安装“ -- 选中CmpTcpIp.library -- 点击“打开”；
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c83de54ea.png)
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c84aa15a9.png)

* 工程中双击“库管理器”  -- “添加库”  -- 双击“Sinsegye Tcp/Ip” ，加载库完成；
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c85090687.png)

**更新安装**

**1、升级工智机TCPIP Server RTE组件**

* 上传升级版deb包到工智机Linux环境的/home/sinsegye目录下，上传方法参考附录；

* 上传完成后在工智机上执行命令安装（参考下方截图，如果模块文件名发生变化则命令行中的文件名做相应更改）

* 重启RTE服务，使新升级的的SF4200被调用

**2、升级IDE侧DataBase的library**

* MetaFacture中点击最上面的菜单栏 ”工具“ -- ”库存储“ ；
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c85ceb342.png)

* 弹出的对话窗中点击”安装“ -- 选中CmpTcpIp.library -- 点击“打开”；
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c8658b4bb.png)
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c86cc0ff1.png)

* 工程中双击“库管理器”  -- “添加库”  -- 双击“Sinsegye Tcp/Ip” ，加载库完成；
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c873bd7bc.png)


**卸载过程**

**1、卸载工智机TCPIP Server RTE组件**

* 工智机上执行命令卸载

* 修改RTE的配置文件，ComponentManger模块下去掉SF4200

* 重启RTE服务

**2、卸载IDE侧的TCPIP library**

* MetaFacture界面点击“工具” -- “库存储”&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c87b80d40.png)

* 对话框中选中安装的的TCPIP库，点击“卸载”
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c883445f7.png)


---
### 技术说明

快速启动

**（一）本例软、硬件配置**

**硬件：**

1. SX5100工智机 MetaOS V24.08.15\_SX5

2. Win10 PC



**软件：**

1. MetaFacutre V1.0.6.2

2. 第三方TCPIP Client工具TCP/UDP Socket调试工具 V2.3



**（二）本例实验要求及原理**

* 实验要求：按照“安装卸载”部分中的“安装过程”配置完成TCPIP Server环境

**1、实验原理**
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c893ad5ac.png)

* 通过 FB\_SocketListen监听第三方TCP/IP客户端的连接，返回监听连接句柄，根据监听句柄和FB\_SocketAccept确认第三方客户端的连接，返回连接句柄，根据连接句柄结合FB\_SocketSend和FB\_SocketReceive进行数据的收发，从而实现通信，当长时间不需要通信时，可以根据FB\_SocketClose关闭建立的连接。

* 上位机和工智机使用EtherNet连接。

* 上位机上，MetaFacture下装工程到工智机。工程中会包含下面的试验操作步骤中的配置。

* 工智机与第三方TCPIP客户端通过EtherNet连接。

**（三）本例实验操作步骤**

**1、TCPIP Server开始监听client连接的实验步骤如下：**

* POU中声明区域调用TCPIP库的功能块FB\_SocketListen

* POU中程序区域调用fbSocketListen,配置TCPIP Server的ip、端口

* 触发bExecute上升沿即可开始监听
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c89d33fa0.png)

**2、TCPIP Server接收Clinet连接的实验步骤如下：**

* POU中声明区域调用TCPIP库的功能块FB\_SocketAccept

* POU中程序区域调用fbSoccketAccept

* 第三方客户端发送连接请求后，TCPIP Server触发fbSoccketAccept的bExecute上升沿，接收Clinet连接；连接成功后bAccepted会变为True;
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c8a6236f1.png)

3、**TCPIP Server接收Client数据的实验步骤如下：**

* POU中声明区域调用TCPIP库的功能块FB\_SocketReceive

* POU中程序区域调用fbSocketReceive

* 第三方Client发送数据后，TCPIP Server触发fbSocketReceive的bExecute上升沿，接收Clinet发送的数据；接收的数据保存到变量arrReceive中；
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c8b0a4196.png)


**4、TCPIP Server发送数据的实验步骤如下：**

* POU中声明区域调用TCPIP库的功能块FB\_SocketSend

* POU中程序区域调用fbSocketSend

* TCPIP Server触发fbSocketSend的bExecute上升沿,发送数据；第三方Client接收到数据；
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c8b940a21.png)

**5、TCPIP Server关闭连接**

* POU中声明区域调用TCPIP库的功能块.FB\_SocketClose;

* POU中程序区域调用fbSocketClose

* TCPIP Server触发fbSocketClose的bExecute上升沿,关闭连接
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c8c08b7ce.png)

* 查看第三方Client,连接断开
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c8c69edd9.png)


（四）实验注意点

* 部分实验有先后顺序要求，建议按照文档中的顺序依次实验

---

### 功能介绍
#### 监听客户端请求
**功能块FB\_SocketListen介绍**
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c8d182daf.png)
参数介绍

* 输入参数

| 参数名称       | 参数类型   | 描述                  |
| ---------- | ------ | ------------------- |
| sLocalHost | STRING | 设置TCPIP Server的IP   |
| nLocalPort | UDINT  | 设置TCPIP Server的端口   |
| bExecute   | BOOL   | 触发上升沿开始监听TCPIP客户端请求 |
| tTimeout   | TIME   | 触发该功能块允许的最大超时时间     |

* 输出参数

| 参数名称      | 参数类型        | 描述                                                                                |
| --------- | ----------- | --------------------------------------------------------------------------------- |
| bBusy     | Bool        | 当功能块被激活时，被置为True，一直保持到收到确认信号                                                      |
| bError    | Bool        | 如果在命令传输过程中发生错误，则在 bBusy 输出被重置后，此输出将被设置成True。                                      |
| nErrId    | UDINT       | ![](images/image-18.png)如果 bError 输出被设置成True，则此参数返回 MetaFacture TCP/IP 连接服务器的错误编号 |
| hListener | ST\_HSOCKET | 新监听套接字的连接句柄。结构体变量 ：句柄号、本地IP、远端IP                                                  |
#### 接受客户端请求
**功能块FB\_SocketAccept介绍**
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c8d9793f8.png)

参数介绍

* 输入参数

| 参数名称      | 参数类型        | 描述                                            |
| --------- | ----------- | --------------------------------------------- |
| hListener | ST\_HSOCKET | 监听套接字的连接句柄。该句柄必须先通过功能块 FB\_SocketListen 请求获取  |
| bExecute  | BOOL        | 上升沿触发接受客户端请求                                  |
| tTimeout  | TIME        | 该功能块执行允许的最大超时时间，即从触发到 到达该时间，如果还没有执行，就不执行，超时报警 |

* 输出参数

| 参数名称      | 参数类型        | 描述                                                                                |
| --------- | ----------- | --------------------------------------------------------------------------------- |
| bAccepted | BOOL        | 如果与远程客户端建立了新连接，则设置此输出为True                                                        |
| bBusy     | BOOL        | 当功能块被激活时，被置为True，一直保持到收到确认信号                                                      |
| bError    | BOOL        | 如果在命令传输过程中发生错误，则在 bBusy 输出被重置后，此输出将被设置成True                                       |
| nErrId    | UDINT       | ![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c8e3c5495.png)
如果 bError 输出被设置成True，则此参数返回 MetaFacture TCP/IP 连接服务器的错误编号 |
| hSocket   | ST\_HSOCKET | 新监听套接字的连接句柄。结构体变量 ：句柄号、本地IP、远端IP                                                  |

#### 接收数据
**功能块FB\_SocketReceive介绍**
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c8ec1c8a0.png)

参数介绍

* 输入参数

| 参数名称     | 参数类型            | 描述                                            |
| -------- | --------------- | --------------------------------------------- |
| hSocket  | ST\_HSOCKET     | 要接收数据的通信伙伴的连接句柄                               |
| cbLen    | UDINT           | 可用于读取数据的最大缓冲区大小（以字节为单位）                       |
| pDest    | POINTER TO BYTE | 接收缓冲区的地址（指针）                                  |
| bExecute | BOOL            | 上升沿触发TCPIP Server接收数据                         |
| tTimeout | Time            | 该功能块执行允许的最大超时时间，即从触发到 到达该时间，如果还没有执行，就不执行，超时报警 |

* 输出参数

| 参数名称      | 参数类型  | 描述                                                                                |
| --------- | ----- | --------------------------------------------------------------------------------- |
| bBusy     | BOOL  | 忙碌状态，True为忙碌，Flase不忙碌                                                             |
| bError    | BOOL  | 报错状态，True报错，Flase无报错                                                              |
| nErrId    | UDINT |![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c8f891adb.png)
如果 bError 输出被设置成True，则此参数返回 MetaFacture TCP/IP 连接服务器的错误编号 |
| nRecBytes | UDINT | 最后成功接收的数据字节数                                                                      |

#### 发送数据
**功能块FB\_SocketSend介绍**
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c9005385b.png)

参数介绍

* 输入参数

| 参数名称     | 参数类型            | 描述                                            |
| -------- | --------------- | --------------------------------------------- |
| hSocket  | ST\_HSOCKET     | 要发送数据的通信伙伴的连接句柄                               |
| cbLen    | UDINT           | 要发送的数据字节数                                     |
| pSrc     | POINTER TO BYTE | 传输缓冲区的地址（指针）                                  |
| bExecute | BOOL            | 通过该输入的上升沿触发功能块                                |
| tTimeout | TIME            | 该功能块执行允许的最大超时时间，即从触发到 到达该时间，如果还没有执行，就不执行，超时报警 |

* 输出参数

| 参数名称   | 参数类型  | 描述                                                                                |
| ------ | ----- | --------------------------------------------------------------------------------- |
| bBusy  | BOOL  | 当功能块被激活时，被置为True，一直保持到收到确认信号                                                      |
| bError | BOOL  | 如果在命令传输过程中发生错误，则在 bBusy 输出被重置后，此输出将被设置成True                                       |
| nErrId | UDINT | ![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c90e9edb8.png)
如果 bError 输出被设置成True，则此参数返回 MetaFacture TCP/IP 连接服务器的错误编号 |

#### 关闭连接
**功能块FB\_SocketClose介绍**
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c9144c440.png)
**参数介绍**

* 输入参数

| 参数名称     | 参数类型        | 描述                                            |
| -------- | ----------- | --------------------------------------------- |
| hSocket  | ST\_HSOCKET | 要关闭的监听器、远程或本地客户端套接字的连接句柄。                     |
| bExecute | BOOL        | 通过该输入的上升沿触发功能块                                |
| tTimeout | TIME        | 该功能块执行允许的最大超时时间，即从触发到 到达该时间，如果还没有执行，就不执行，超时报警 |

* 输出参数

| 参数名称   | 参数类型  | 描述                                                                                |
| ------ | ----- | --------------------------------------------------------------------------------- |
| bBusy  | BOOL  | 当功能块被激活时，被置为True，一直保持到收到确认信号                                                      |
| bError | BOOL  | 如果在命令传输过程中发生错误，则在 bBusy 输出被重置后，此输出将被设置成True                                       |
| nErrId | UDINT | ![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c91df2e70.png)
如果 bError 输出被设置成True，则此参数返回 MetaFacture TCP/IP 连接服务器的错误编号 |

---
### 错误诊断

连接异常

* 连接异常导致数据收发异常；
![](https://resource.helplook.net/docker_production/3648ne/article/QusDH81S/6800c92813271.png)

* 分析：第三方客户端连接TCPIP Server，都需要TCPIP Server触发FB\_SocketAccept来接受请求，否则连接不成功；